package cn.weipass.pos.sdk;

import java.util.List;

import org.json.JSONObject;

import android.graphics.Bitmap;

/**
 * 
 * 旺POS授权管理器
 * <p/>
 * 通过旺POS授权管理器，可以获知当前设备的操作员级别，也可以要求系统对当前操作进行指定级别的授权。
 * 
 * 获取实例的方式：WeiposImp.as().getService(AuthorizationManager.class);
 * @since 1.1
 * @author Happy
 * 
 */
public interface AuthorizationManager extends Initializer{
	/**
	 * 授权失败
	 */
	public static final int AuthorFail = 0;
	/**
	 * 授权成功
	 */
	public static final int AuthorSuccess = 1;
	/**
	 * 授权异常
	 */
	public static final int AuthorException = 2;
	
	/**
	 * 请求授权
	 */
	public void requestAuthorize(String packageName, String pkg, String authorName);
	/**
	 * 结果返回对象
	 * @author hedong
	 *
	 */
	public interface AuthorizeCallback{
		public void getAuthorizeResult(int result);
	}
	public void setAuthorizeCallback(AuthorizeCallback callback);
	
	/**
	 * 设置权限列表
	 */
	public void setAuthorizeApplicationList(String pkg, Bitmap bitmap,int size, List<String> list);
	/**
	 * 检查用户输入的用户名和密码 与 当前登录的用户是否是同一个用户
	 */
	public boolean checkUserInputStaffEnter(String userNumber, String userPassword);
	/**
	 * 检查用户输入的用户名和密码是否正确
	 */
	public boolean checkUserInput(String userNumber, String userPassword);
	/**
	 * 检查是否开启了员工登录
	 */
	public boolean checkStaffEnterStatus();
	/**
	 * 跳转到员工登录界面
	 */
	public boolean startStaffEnter(String packageName);
	
	/**
	 * 获取当前登录用户的信息及权限
	 */
	public JSONObject getEnterStaffInfo();
}
