package cn.weipass.pos.sdk;

import cn.weipass.service.bizInvoke.RequestInvoke;
import cn.weipass.service.bizInvoke.RequestResult;

/**
 * 
 * 旺POS业务服务调用类
 * <p/>
 * 通过旺POS业务服务调用类，可以做业务服务请求，例如调用起收银app
 * 
 * 获取实例的方式：WeiposImp.as().getService(BizServiceInvoker.class);
 * @since 1.1
 * @author hedong
 * 
 */
public interface BizServiceInvoker extends Initializer{
	/**
	 * 未请求
	 */
	public static final int REQ_NONE = -1;
	/**
	 * 请求返回码,正常
	 */
	public static final int REQ_SUCCESS = 0;
	/**
	 * 请求返回码，无效参数
	 */
	public static final int REQ_ERR_INVAILD_PARAM = 1;
	/**
	 * 请求返回码，没有对应服务
	 */
	public static final int REQ_ERR_NO_SERVICE = 2;
	/**
	 * 请求返回码，未定义的合作伙伴
	 */
	public static final int REQ_ERR_NO_BP = 3;

	/**
	 * 默认启动类型，启动Main Activity
	 */
	public static final int LAUNCH_TYPE_DEFAULT = 0;
	/**
	 * 启动指定Activity类型
	 */
	public static final int LAUNCH_TYPE_ACTIVITY = 1;
	/**
	 * 启动指定service类型
	 */
	public static final int LAUNCH_TYPE_SERVICE = 2;

	/**
	 * 请求服务
	 * 
	 * @param req
	 *            请求对象
	 * @return 操作码 <br/>
	 *         {@link #REQ_NONE} <br/>
	 *         {@link #REQ_SUCCESS} <br/>
	 *         {@link #REQ_ERR_NO_BP} <br/>
	 *         {@link #REQ_ERR_NO_SERVICE} <br/>
	 *         {@link #REQ_ERR_INVAILD_PARAM}
	 */
	public RequestResult request(RequestInvoke req);

	/**
	 * 设置响应监听接口
	 * 
	 * @param listener
	 *            响应监听接口
	 */
	public void setOnResponseListener(OnResponseListener listener);
	/**
	 * bp是否订阅此服务
	 * @param sdCode 服务定义
	 * @param bpId 合作伙伴的ID
	 * @return  是否订阅此服务的标记
	 */
	public boolean isSubscribeService(String sdCode,String bpId);
	
	/**
	 * 订阅此服务
	 * @param sdCode 服务定义
	 * @param bpId 合作伙伴的ID
	 */
	public void subscribeService(String sdCode,String bpId);

	/**
	 * 响应监听类
	 * 
	 * @author hedong
	 * 
	 */
	public interface OnResponseListener {
		/**
		 * 响应回调
		 * 
		 * @param sdCode
		 *            服务定义code
		 * @param token
		 *            请求token
		 * @param data
		 *            返回数据
		 */
		public void onResponse(String sdCode, String token, byte[] data);

		/**
		 * 完成订阅服务的回调
		 * 
		 * @param result
		 *            true：订阅成功；false：订阅失败
		 * @param err
		 *            错误信息，订阅成功时为null
		 */
		public void onFinishSubscribeService(boolean result, String err);
	}
}
