package cn.weipass.pos.sdk;
/**
 * 
 * 旺POS业务服务提供类
 * <p/>
 * 通过旺POS业务服务提供类，可以响应业务请求
 * 
 * 获取实例的方式：WeiposImp.as().getService(BizServiceProvider.class);
 * @since 1.1
 * @author hedong
 * 
 */
public interface BizServiceProvider extends Initializer{
	/**
	 * 请求的Intent中key名称，服务定义Code,数据类型String
	 */
	public static final String KEY_REQ_SDCODE = "sdCode";
	/**
	 * 请求的Intent中key名称，合作伙伴ID,数据类型String
	 */
	public static final String KEY_REQ_BPID = "bpId";
	/**
	 * 请求的Intent中key名称，请求token,数据类型String
	 */
	public static final String KEY_REQ_TOKEN = "requestToken";
	/**
	 * 请求的Intent中key名称，请求参数,数据类型byte[]
	 */
	public static final String KEY_REQ_PARAMS = "requestParams";
	/**
	 * 服务端的请求序列号
	 */
	public static final String KEY_SEQ_NO = "seqNo";
	/**
	 * 响应返回码,无操作
	 */
	public static final int RESP_NONE =-1;
	/**
	 * 响应返回码,正常
	 */
	public static final int RESP_SUCCESS = 0;
	/**
	 * 响应返回码,没有token
	 */
	public static final int RESP_ERR_NO_TOKEN = 1;
	/**
	 * 响应返回码,错误token格式
	 */
	public static final int RESP_ERR_INVAILD_TOKEN = 2;

	/**
	 * 响应返回码,没有找到服务
	 */
	public static final int RESP_ERR_NO_SERVICE = 3;
	/**
	 * 响应返回码,没有回调对象，不能将结果通知到调用客户端
	 */
	public static final int RESP_ERR_NO_CALLBACK = 4;
	/**
	 * 响应返回码,与调用客户端的连接中断，不能将结果通知到调用客户端
	 */
	public static final int RESP_ERR_CALLBACK_DISCONNECT = 5;
	/**
	 * 响应返回码，无效参数
	 */
	public static final int RESP_ERR_INVAILD_PARAM = 6;
	
	/**
	 * 响应业务调用
	 * @param token 业务调用请求token
	 * @param data 返回数据
	 * @return 返回码
	 * <br/>{@link #RESP_NONE}
	 * <br/>{@link #RESP_SUCCESS}
	 * <br/>{@link #RESP_ERR_NO_TOKEN}
	 * <br/>{@link #RESP_ERR_INVAILD_TOKEN}
	 * <br/>{@link #RESP_ERR_NO_SERVICE}
	 * <br/>{@link #RESP_ERR_NO_CALLBACK}
	 * <br/>{@link #RESP_ERR_CALLBACK_DISCONNECT}
	 * <br/>{@link #RESP_ERR_INVAILD_PARAM}
	 */
	public int response(String token,byte[] data);
}
