package cn.weipass.pos.sdk;


import android.os.RemoteException;

import cn.weipass.pos.sdk.impl.BlueBoxManagerImp;
import cn.weipass.service.bluetoothbox.IInitConnectCallback;

/**
 * Created by bin on 2016/10/25.
 */
public interface BlueBoxManager  {

    /**
     * 蓝牙开关未打开
     */
    public static final int BLUETOOTH_CLOSE= -1;

    /**
     * 蓝牙未配对
     */
    public static final int BLUETOOTH_DISCONNECT= -2;

    /**
     * 发送数据失败
     */
    public static final int BLUETOOTH_SEND_FAIL= -3;

    public int open();

    public int sendValue(String value);

    public void setOnInitListener(InitConnectCallback callback);

    public  class InitConnectCallback extends IInitConnectCallback.Stub{

        @Override
        public void onInitResult(int status, String message) throws RemoteException {

        }
    }

    public String getSn();
}
