package cn.weipass.pos.sdk;

/**
 * 旺POS平台数据通讯服务操作类
 * <p/>
 * 上层业务程序除了自已建立网络数据通道外，旺POS平台提供了稳定可靠的数据通讯通道，旺POS平台的数据通道除了一般的网络服务调用能力外，还具有及时高效的服务端数据PUSH功能。
 * <p/>
 * 获取实例的方式：WeiposImp.as().getService(DataChannel.class);
 * @since 1.0
 * @author hedong
 * 
 */
public interface DataChannel extends Initializer{

	/**
	 * 服务端数据PUSH监听接口
	 * 
	 * @since 1.0
	 * @author hedong
	 * 
	 */
	public interface OnPushDataListener {
		/**
		 * 收到服务端数据PUSH的事件
		 * 
		 * @param data_json
		 *            PUSH数据内容，JSON表述
		 */
		public void onDataReceived(String data_json);
	}

	/**
	 * 网络服务请求回调接口
	 * 
	 * @since 1.0
	 * @author hedong
	 * 
	 */
	public interface ResponseCallback {
		/**
		 * 调用后正确数据返回事件
		 * 
		 * @param data_json
		 *            返回数据，JSON表述
		 */
		public void onResponse(final String data_json);

		/**
		 * 调用后异常事件
		 * 
		 * @param error
		 *            异常描述
		 */
		public void onError(final String error);
	}

	/**
	 * 网络业务请求，该方法需实现对应的微POS平台服务端API中DataRecived方法
	 * <p/>
	 * 该方法为异步方法，需设置回调接口来获取返回响应
	 * 
	 * @see ResponseCallback
	 * 
	 * @param data_josn
	 *            请求数据JSON表述
	 * @param responseCallback
	 *            调用返回回调类
	 */
	public void request(String data_josn, ResponseCallback responseCallback);

	/**
	 * 设置push监听对象，该方法的数据来源于对应的旺POS平台服务端API中PushData方法
	 * 
	 * @see OnPushDataListener
	 * 
	 * @param onPushDataListener push监听对象
	 */
	public void setOnPushDataListener(OnPushDataListener onPushDataListener);

}
