package cn.weipass.pos.sdk;

public interface EsamManager extends Initializer{
	/**
	 * 存储类型，esam
	 */
	public static final int STORE_TYPE_ESAM = 0;
	/**
	 * 存储类型，stm32
	 */
	public static final int STORE_TYPE_STM32 = 1;
	
	public void setSnCode(String snCode);
	/**
	 * 清空esam芯片数据
	 */
	public void clearAllFile();
	
	/**
	 * 获取保存在设备芯片的sn号
	 */
	public String getDeviceSNCode();

	/**
	 * 保存用户id（用于出厂初始化）
	 * 
	 * @param uid 用户id
	 * @return 操作是否成功标记
	 */
	public boolean saveUid( byte[] uid);
	/**
	 * 获取提交到服务器的参数，用作于请求获取服务器端的公钥
	 * （用于出厂初始化）
	 * @return 提交到服务器的参数
	 */
	public byte[] getReqWebServerParam();
	
	/**
	 * 保存从服务器回传的数据，包含sn号，服务器公钥
	 * （用于出厂初始化）
	 * @param data 服务器回传的数据
	 */
	public void saveSNAndWebServerPublicKey(byte[] bs);
	
	/**
	 * 获取服务端的公钥，从芯片中读取
	 * 
	 * @return
	 */
	public byte[] getWebServerPublicKey();
	
	/**
	 * 获取SN号，从芯片中读取
	 * 
	 * @return
	 */
	public byte[] getSN();
	
	/**
	 * 非对称算法 RSA 的私钥对加密数据进行解密
	 * 
	 * @param data
	 * @return
	 */
	public byte[] dataDecrypt(byte[] data);
	/**
	 * 保存设备snCode到芯片
	 * 
	 * @param snCode
	 *            设备snCode
	 */
	public boolean saveDeviceSNCode(String snCode);
	
	/**
	 * 是否初始化成功
	 * 
	 * @return
	 */
	public boolean isInit();
	/**
	 * 是否可用
	 * @return
	 */
	public boolean isEnable();
	/**
	 * 返回存储类型
	 * @return 0:esam;1:stm32
	 */
	public int getStoreType();
}
