package cn.weipass.pos.sdk;

/**
 * Created by Administrator on 2017/4/23.
 * 燃气卡服务类,处理燃气卡卡相关业务
 */

public interface GasCardManager {
    /**
     * 打开读卡器
     * @return 操作码 0为成功，其他为错误码
     */
    int open();
    /**
     * 关闭读卡器
     * @return 操作码 0为成功，其他为错误码
     */
    int close();
    /**
     * 检测卡是否在位
     * @return 操作码 0为成功，其他为错误码
     */
    int check();
    /**
     * 获取卡信息
     * @return 卡信息
     */
    byte[] readCardInfo(int addr,int len);
    /**
     * 验证卡
     * @param pwd 密码
     * @return 操作码 0为成功，其他为错误码
     */
    int verify(byte[] pwd);
    /**
     * 写卡
     * @param pwd 密码
     * @param addr 地址
     * @param data 数据
     * @return 操作码 0为成功，其他为错误码
     */
    int write(byte[] pwd,int addr,byte[] data);


    /**
     * 读取密码
     * @param outData 密码剩余次数
     */
    int Logic_ReadPWDegree( byte []outData);
    /**
     * 修改密码
     * @param pwLen 密码长度
     * @param pwData 密码数据
     */
    int Logic_ModifyPW(int pwLen,  byte[] pwData);
}
