package cn.weipass.pos.sdk;



/**
 * 打印接口
 * 
 * @author hedong
 * 
 */
public interface IPrint extends Initializer{
	/**
	 * 打印事件常量，未知事件
	 */
	public static final int EVENT_UNKNOW = 0;
	/**
	 * 打印事件常量，缺纸
	 */
	public static final int EVENT_NO_PAPER = 1;
	/**
	 * 打印事件常量，卡纸
	 */
	public static final int EVENT_PAPER_JAM = 2;
	/**
	 * 打印事件常量，打印成功
	 */
	public static final int EVENT_OK = 3;
	/**
	 * 打印事件常量，打印机高温
	 */
	public static final int EVENT_HIGH_TEMP=4;
	/**
	 * 连接打印机成功，已经连接到打印机
	 */
	public static final int EVENT_CONNECTED = 5;
	/**
	 * 连接打印机失败
	 */
	public static final int EVENT_CONNECT_FAILD = 6;
	/**
	 * 打印机状态正常
	 */
	public static final int EVENT_STATE_OK = 7;
	/**
	 * 打印失败
	 */
	public static final int EVENT_PRINT_FAILD=8;

	/**
	 * 打印事件监听接口
	 * 
	 * @since 1.0
	 * @author Happy
	 * 
	 */
	public interface OnEventListener {
		/**
		 * 事件方法
		 * 
		 * @see IPrint#EVENT_UNKNOW
		 * @see IPrint#EVENT_NO_PAPER
		 * @see IPrint#EVENT_PAPER_JAM
		 * @see IPrint#EVENT_OK
		 * @see IPrint#EVENT_HIGH_TEMP
		 * @see IPrint#EVENT_CONNECTED
		 * @see IPrint#EVENT_CONNECT_FAILD
		 * @see IPrint#EVENT_STATE_OK
		 * @see IPrint#EVENT_PRINT_FAILD
		 * @param what
		 *            事件类型
		 * @param info
		 *            事件消息
		 */
		public void onEvent(final int what, final String info);
	}
	
	/**
	 * 设置打印事件监听对象
	 * 
	 * @see OnEventListener
	 * 
	 * @param onEventListener
	 *            打印事件监听对象
	 */
	public void setOnEventListener(OnEventListener onEventListener);
	
	/**
	 * 定位策略枚举值
	 * 
	 * @since 1.0
	 * @author Happy
	 * 
	 */
	public enum Gravity {
		LEFT, CENTER, RIGHT
	}

	/**
	 * 打印条码类型，code39
	 */
	public static final int BARTYPE_CODE_39=4;
	/**
	 * 打印条码类型，code128
	 */
	public static final int BARTYPE_CODE_128=73;
	
	/**
	 * 开始新的一行
	 */
	public void startNewLine();

	/**
	 * 打印二维码
	 * 
	 * @param content
	 *            二维码内容
	 * @param side
	 *            二维码大小（边长）
	 * @param gravity
	 * @see IPrint.Gravity
	 */
	public void printQrCode(String content, int side, Gravity gravity);
	
	/**
	 * 打印条码
	 * 
	 * @param content
	 *            条码内容
	 * @param width
	 *            条码大小（宽）
	 * @param height 条码大小（高）
	 * @param barType 条码编码类型：<br>{@link #BARTYPE_CODE_39}<br>{@link #BARTYPE_CODE_128}
	 * @see IPrint.Gravity
	 */
	public void printBarCode(String content, int width, int height, int barType);

	/**
	 * 打印图片
	 * 
	 * @param imageBytes
	 *            图片Bitmap内容
	 * @param gravity
	 * @see IPrint.Gravity
	 */
	public void printImage(byte[] imageBytes, Gravity gravity);

	/**
	 * 打印任务结束，切纸
	 */
	public void cutting();

	/**
	 * 进纸
	 * 
	 * @param stepCount
	 *            步长
	 */
	public void feed(int stepCount);
	
	
	/**
	 * 获取打印机状态
	 */
	public int queryPrinterState();

	/**
	 * 获取打印机状态
	 * @param pkgName 调用者包名
	 */
	public void checkPrinterState(String pkgName);
	/**
	* 设置行间距
	* @param add 表示行额外增加的高度
	* @param mult 表示行高度的倍数，例如1表示1倍行高，0.5表示行高的一半
	*/
	public void setLineSpacingExt(float add, float mult);
}
