package cn.weipass.pos.sdk;


/**
 * 
 * 基于点阵实现的打印设备操作类
 * <p/>
 * 
 * 获取实例的方式：WeiposImp.as().getService(LatticePrinter.class);
 * 
 * @since 1.0
 * @author hedong
 * 
 */
public interface LatticePrinter extends IPrint {
	/**
	 * 字体大小枚举值，以下为各种字体大小在各个平台的大小：<br>
	 * <table border=1>
	 *     <tr>
	 *         <td>设备类型</td>
	 *         <td>SMALL</td>
	 *         <td>MEDIUM</td>
	 *         <td>LARGE</td>
	 *         <td>EXTRALARGE</td>
	 *     </tr>
	 *     <tr>
	 *         <td>pos2</td>
	 *         <td>16x16</td>
	 *         <td>24x24</td>
	 *         <td>32x32</td>
	 *         <td>48x48</td>
	 *     </tr>
	 *     <tr>
	 *         <td>pos3</td>
	 *         <td>16x16</td>
	 *         <td>24x24</td>
	 *         <td>32x32</td>
	 *         <td>48x48</td>
	 *     </tr>
	 * </table>
	 * 单位为px。一行的宽度为384
	 * @since 1.0
	 * @author Happy
	 * 
	 */
	public enum FontSize {
		SMALL, MEDIUM, LARGE,EXTRALARGE
	}
	/**
	 * 字体类型枚举值
	 * <p/>
	 * normal: 正常; BOLD: 粗体 ;italic :斜体
	 * 
	 * @author hedong
	 * 
	 */
	public enum FontStyle {
		NORMAL, BOLD,ITALIC
	}

	/**
	 * 字体枚举值
	 * SONG:宋体
	 * @author hedong
	 * 
	 */
	public enum FontFamily {
		SONG
	}
	
	/**
	 * 提交打印，调用此函数后打印机才会真正开始打印
	 */
	public void submitPrint();
	
	/**
	 * 打印文本内容
	 * 
	 * @param text
	 *            内容
	 * @param family {@link FontFamily}字体
	 * @see FontFamily
	 * @param size {@link FontSize} 字体大小。
	 * @see FontSize
	 * @param style {@link FontStyle} 字体样式
	 * @see FontStyle
	 */
	public void printText(String text, FontFamily family, FontSize size, FontStyle style);
	/**
	* 设置行间距
	* @param spacing 表示行高度的倍数，例如1表示1倍行高，0.5表示行高的一半
	*/
	public void setLineSpacing(double spacing);
	
	/**
	 * 获得文本内容的宽度和高度<br>
	 * 第1个元素为宽度，第二个元素为高度
	 * @param text
	 *            内容
	 * @param family
	 * @see FontFamily
	 * @param size
	 * @see FontSize
	 * @param style
	 * @see FontStyle
	 * 
	 */
	public int[] getTextFontSize(String text, FontFamily family, FontSize size, FontStyle style);
	
	/**
	 * 检查是否按走纸键
	 * @hide
	 */
	public void checkKeyPress();
	
	/**
	 * 向打印机发送数据
	 * 
	 * @param datas
	 *            数据内容
	 * @param len
	 *            数据长度
	 */
	public void writeData(byte[] datas, int len);
}
