package cn.weipass.pos.sdk;
/**
 * 
 * led灯操作类
 * <p/>
 * 
 * 获取实例的方式：WeiposImp.as().getService(LedLightManager.class);
 * @since 1.0
 * @author Hedong
 * 
 */
public interface LedLightManager extends Initializer{
	/**
	 * led灯颜色，红色
	 */
	public static final int COLOR_RED = 128;
	/**
	 * led灯颜色，绿色
	 */
	public static final int COLOR_GREEN = 32;
	/**
	 * led灯颜色，蓝色
	 */
	public static final int COLOR_BLUE = 16;
	/**
	 * led灯颜色，黄色
	 */
	public static final int COLOR_YELLOW = 64;
	
	/**
	 * 设置led灯状态
	 * 
	 * @param colorType 颜色类型
	 * @see LedLightManager#COLOR_BLUE
	 * @see LedLightManager#COLOR_GREEN
	 * @see LedLightManager#COLOR_RED
	 * @see LedLightManager#COLOR_YELLOW
	 * @param isTurnOn 开关标记 true:开；false：关
	 */
	public void setLedlightState(int colorType,boolean isTurnOn);
	
	/**
	 * 设置led闪烁
	 * 
	 * @param colorType 颜色类型
	 * @see LedLightManager#COLOR_BLUE
	 * @see LedLightManager#COLOR_GREEN
	 * @see LedLightManager#COLOR_RED
	 * @see LedLightManager#COLOR_YELLOW
	 * @param onT 点亮时长，单位毫秒
	 * @param offT 熄灭时长，单位毫秒
	 */
	public boolean flash(int colorType,int onT,int offT);
}
