package cn.weipass.pos.sdk;

import java.util.List;

/**
 * 打点日志
 * @author hedong
 *
 */
public interface Logger extends Initializer{
	/**
	 * 详细信息的日志
	 * @param tag 日志标记
	 * @param message 日志内容
	 */
	public void v(String tag, String message);

	/**
	 * 调试信息的日志
	 * @param tag 日志标记
	 * @param message 日志内容
	 */
	public void d(String tag, String message);

	/**
	 * 通告信息的日志
	 * @param tag 日志标记
	 * @param message 日志内容
	 */
	public void i(String tag, String message);

	/**
	 * 警告信息的日志
	 * @param tag 日志标记
	 * @param message 日志内容
	 */
	public void w(String tag, String message);

	/**
	 * 错误信息的日志
	 * @param tag 日志标记
	 * @param message 日志内容
	 */
	public void e(String tag, String message);

	/**
	 * 查询日志文件名称
	 * @return
	 */
	public List<String> queryZipLogFileNames();
	
	/**
	 * 打包日志文件
	 * @param fileName 文件名称
	 */
	public void zipLogFileAndDelOrg(String fileName);
	
	/**
	 * 日志快速写入
	 */
	public void zipLogCached();
}
