package cn.weipass.pos.sdk;
/**
 * 
 * 磁卡读卡器操作类
 * <p/>
 * 获取实例的方式：WeiposImp.as().getService(MagneticReader.class);
 * @since 1.0
 * @author Hedong
 * 
 */
public interface MagneticReader extends Initializer{
	/**
	 * 读取磁卡数据(经过解析)
	 * @return 磁卡数据
	 */
	public byte[] readCard();
	/**
	 * 读取磁卡解码后的数据
	 * @return 磁卡解码后的数据
	 */
	public String getCardDecodeData();
	/**
	 * 读取磁卡解码后的3轨数据
	 * @return 3轨数据
	 */
	public String[] getCardDecodeThreeTrackData();
	
	/**
	 * 获取加密后的三轨数据
	 * @param dstKeyIdx 密钥索引号,加密:TEK 索引号
	 */
	public String[] getEncrypt3TrackData(byte dstKeyIdx);

	/**
	 * 读取磁卡原始数据(未经解析的原始数据)
	 * @return 磁卡数据
	 */
	public byte[] readCardOrg();
}
