package cn.weipass.pos.sdk;

import cn.weipass.service.ped.PwdDlgConfig;

/**
 * 密码键盘,PED服务
 * 
 * @see Weipos#openPrinter()
 * @author hedong
 * 
 */
public interface Ped extends Initializer {
	/**
	 * 擦除事件
	 */
	public static final int EVENT_ERASE = 0;
	/**
	 * 写KEYs
	 */
	public static final int EVENT_WRITEKEY = 1;
	/**
	 * 显示密码输入框
	 */
	public static final int EVENT_SHOWPWDDIALOG = 2;
	/**
	 * 运算 MAC
	 */
	public static final int EVENT_GETMAC = 3;
	/**
	 * 进行 des 加解密运算
	 */
	public static final int EVENT_CALCDES = 4;
	/**
	 * 密码键盘初始化时的事件
	 */
	public static final int EVENT_DIALOG_ON_CREATE=5;
	/**
	 * 输入密码时，按键按下事件
	 */
	public static final int EVENT_INPUT_KEYDOWN=6;
	/**
	 * 输入密码时，按键弹起事件
	 */
	public static final int EVENT_INPUT_KEYUP=7;
	/**
	 * 操作成功
	 */
	public static final int RETCODE_SUCCESS = 0;
	/**
	 * 擦除失败
	 */
	public static final int RETCODE_ERR_ERASE = -1;
	/**
	 * 写入KEY失败
	 */
	public static final int RETCODE_ERR_WRITEKEY = -2;
	/**
	 * 显示密码输入框失败，mode参数错误
	 */
	public static final int RETCODE_ERR_PWD_MODE = -3;
	/**
	 * 显示密码输入框失败，初始化失败
	 */
	public static final int RETCODE_ERR_PWD_INIT = -4;
	/**
	 * 显示密码输入框失败，获取pin 值失败
	 */
	public static final int RETCODE_ERR_PWD_GETPIN = -5;
	/**
	 * 显示密码输入框失败，输入的空密码
	 */
	public static final int RETCODE_ERR_PWD_NONE = -6;
	/**
	 * 显示密码输入框失败，用户取消操作
	 */
	public static final int RETCODE_ERR_PWD_CANCEL = -7;
	/**
	 * 显示密码输入框失败，用户操作超时
	 */
	public static final int RETCODE_ERR_PWD_OVERTIME = -8;
	/**
	 * 其他错误
	 */
	public static final int RETCODE_ERR_OTHER = -100;

	/**
	 * 默认密码键盘中按钮个数
	 */
	public static final int DEFAULT_PWD_DIALOG_BTN_COUNT = 12;

	/**
	 * 擦除 PED
	 * @return 返回操作结果
	 */
	public boolean erase();

	/**
	 * 写密钥
	 * 
	 * @param srcKeyType
	 *            源密钥类型 
	 * <br>{@link #PED_EXPRESS}
	 * <br>{@link #PED_TLK}
	 * <br>{@link #PED_TMK}
	 * <br>{@link #PED_RSA_POS3}
	 * @param srcKeyIdx
	 *            源密钥索引 1、写入密码明文填 0x00,(只有当 TLK 未写入时允许明文写) 2、 PED_TLK:0x01 3、
	 *            PED_TMK :0x01~0x40
	 * @param dstKeyType
	 *            目标密钥类型: 
	 * <br>{@link #PED_TLK}
	 * <br>{@link #PED_TMK}
	 * <br>{@link #PED_TPK}
	 * <br>{@link #PED_TAK}
	 * <br>{@link #PED_TDK}
	 * <br>{@link #PED_TEK}
	 * <br>{@link #PED_TTK}
	 * <br>{@link #PED_MAGNET_ENCRYPT}
	 * <br>注意:dstKeyType>= srcKeyType
	 * @param dstKeyIdx
	 *            目标密钥索引: PED_TLK:0x01 PED_TMK:1~64 当写入 PED_TPK、 PED_TAK、
	 *            PED_TDK、 PED_TEK、 PED_TTK，采用同一个密钥类型、同一个密钥索引作为源密钥时，目标密钥索引应各不一样
	 * @param algthflag
	 *            算法标识: 0x00:3DES 0x10:AES 0x20:SM4 110001:银联 110002:自定义3des
	 * @param bufIn
	 *            目标密钥明文或密文: 目标密钥长度 TLK:16 或者 24 字节 ucDstKeyLen 只能为 8/16/24,并且 当
	 *            ucDstKeyLen 为 8 时 , 这 个 密 钥 只 能 用 于 DES 计 算,ucDstKeyLen 为 16 或
	 *            24 时,可以用于 TDES 计算
	 * @param mode
	 *            验证模式： 0、 1、 2、 3，具体每个模式的算法请看后续参数
	 * @param aucCheckBufIn
	 *            校验数据： aucCheckBuf(校验数据): aucCheckBuf: 当 mode=0 时 aucCheckBuf
	 *            的值无效,系统认为不验证 KCV, 所以 aucCheckBuf 可以为无效数据 mode=1 用目标密钥对 8 个字节的
	 *            0x00 计算 TDES 加密,得到 的密文的前 4 个字节即为KCV mode=2 对目的密钥进行奇校验，再按
	 *            mode=1 时进行校验 mode=3 对目的密钥进行偶校验，再按 mode=1 时进行校验 aucCheckBuf + 1
	 *            指向 KCV 的值
	 * @return 返回操作结果
	 */
	public boolean writeKey(int srcKeyType, int srcKeyIdx, int dstKeyType, int dstKeyIdx, int algthflag, byte[] bufIn,
			int mode, byte[] aucCheckBufIn);

	/**
	 * 显示密码输入键盘
	 * 
	 * @param title
	 *            标题
	 * @param keyIdx
	 *            [1~64]， TPK 的索引
	 * @param expPinLenIn
	 *            Pin 的长度指示串，例如，支持 4 或 6 或 8 的长度 pin 并且 支 持 不 输 入 密 码 直 接 按 确 认
	 *            键 ， 则 此 字 符 串为:” 0,4,6,8” ,0 表示允许直接按确认键。密码长度最长 12 位
	 * @param cardNum
	 *            帐号，此参数为 null 时，自动全 0
	 * @param mode
	 *            0x00 ISO9564 格式 0 0x01 ISO9564 格式 1 0x02 ISO9564 格式 3 0x03 HK
	 *            EPS 专用格式
	 * @param timeout
	 *            Pin 扫描超时时间，单位为 ms，最大为 300000ms
	 */
	public void showTPPwdDialog(String title, int keyIdx, String expPinLenIn, String cardNum, int mode, long timeout);

	/**
	 * 显示自定义密码键盘
	 * @param config 密码键盘配置对象
	 * <br>{@link PwdDlgConfig}
     */
	public void showCustomPwdDialog(PwdDlgConfig config) throws Exception;

	/**
	 * 事件回调对象
	 * 
	 * @author hedong
	 * 
	 */
	public interface EventCallback {
		/**
		 * 调用回调方法
		 * 当事件类型为EVENT_INPUT_KEYDOWN或者EVENT_INPUT_KEYUP时，retCode表示已经输入的密码个数
		 * @param event  事件类型
		 * <br>{@link Ped#EVENT_ERASE}
		 * <br>{@link Ped#EVENT_WRITEKEY}
		 * <br>{@link Ped#EVENT_SHOWPWDDIALOG}
		 * <br>{@link Ped#EVENT_GETMAC}
		 * <br>{@link Ped#EVENT_CALCDES}
		 * <br>{@link Ped#EVENT_DIALOG_ON_CREATE}
		 * <br>{@link Ped#EVENT_INPUT_KEYDOWN}
		 * <br>{@link Ped#EVENT_INPUT_KEYUP}
		 * @param retCode 返回码:
		 * <br>{@link Ped#RETCODE_SUCCESS}
		 * <br>{@link Ped#RETCODE_ERR_ERASE}
		 * <br>{@link Ped#RETCODE_ERR_WRITEKEY}
		 * <br>{@link Ped#RETCODE_ERR_PWD_MODE}
		 * <br>{@link Ped#RETCODE_ERR_PWD_INIT}
		 * <br>{@link Ped#RETCODE_ERR_PWD_GETPIN}
		 * <br>{@link Ped#RETCODE_ERR_PWD_NONE}
		 * <br>{@link Ped#RETCODE_ERR_PWD_CANCEL}
		 * <br>{@link Ped#RETCODE_ERR_PWD_OVERTIME}
		 */
		public void onEvent(int event, int retCode);
		
		/**
		* 输入完密码后的回调
		* 
		* @param pinblk  返回密码加密数据
		*/
		public void onInputPwdFinished(byte[] pinblk);
	}

	/**
	 * 设置ped事件监听对象Callback 为空时表示注销监听对象
	 * 
	 * @param callback
	 *            事件类型
	 */
	public void setEventCallback(EventCallback callback);

	/**
	 * 写入密码明文填 0x00,(只有当 TLK 未写入时允许明文写)
	 */
	public static final int PED_EXPRESS=0;
	/**
	 * 传输秘钥
	 */
	public static final int PED_TLK = 1;
	/**
	 * 终端主秘钥
	 */
	public static final int PED_TMK = 2;
	/**
	 * 密码键盘秘钥
	 */
	public static final int PED_TPK = 3;
	/**
	 * 银行卡磁道加密密钥
	 */
	public static final int PED_TAK = 4;
	/**
	 * 解密秘钥 3des、aes、des
	 */
	public static final int PED_TDK = 5;
	/**
	 * 加密秘钥
	 */
	public static final int PED_TEK = 6;
	public static final int PED_TTK = 9;
	/**
	 * pos3专用的源密钥类型
	 */
	public static final int PED_RSA_POS3 = 10000;
	/**
	 * 磁道加密源秘钥类型
	 */
	public static final int PED_MAGNET_ENCRYPT=10001;
	/**
	 * pos3专用的源密钥索引
	 */
	public static final int SRC_KEY_INDEX_RSA_POS3=10000;
	/**
	 * 算法标识3DES
	 */
	public static final int Algthflag_DES = 0;
	/**
	 * 算法标识AES
	 */
	public static final int Algthflag_AES = 16;
	/**
	 * 算法标识SM4
	 */
	public static final int Algthflag_SM4 = 32;
	/**
	 * 扩展算法标识银联
	 */
	public static final int Algthflag_UnionPay = 110001;
	/**
	 * 扩展算法标识3des
	 */
	public static final int Algthflag_3Des = 110002;
	public static final int KeyOfUnLockTerminal = 128;
	public static final int KeyOfAdministrator_A = 129;
	public static final int KeyOfAdministrator_B = 130;
	public static final int KeyOfUnLockTerminal_NEW = 132;

	public static final int KeyOfAdministrator_A_NEW = 133;

	public static final int KeyOfAdministrator_B_NEW = 134;

	/**
	 * ISO9564 格式 0
	 */
	public static final int MODE_ISO9564_0 = 0;
	/**
	 * ISO9564 格式 1
	 */
	public static final int MODE_ISO9564_1 = 1;
	/**
	 * ISO9564 格式 3
	 */
	public static final int MODE_ISO9564_3 = 3;
	/**
	 * HK EPS 专用格式
	 */
	public static final int MODE_HK_EPS = 4;
	
	/**
	 * 运算 MAC(非 DUKPT)
	 * 
	 * @param keyIdx TAK 的密钥索引号 1~64
	 * @param dataIn 需进行 MAC 运算的数据包
	 * @param mode 运算模式:
	 *运算模式: 0:将 BLOCK1 用 MAC 密钥做 DES/TDES 加密,加密结果与 BLOCK2 进行逐位异或后再用 TAK 做 DES/TDES 加密,依次进行得到 8 字节的加密结果    ECB
	 *<br>
	 *1:将 BLOCK1 和 BLOCK2 进行逐位异或,异或结果与BLOCK3 进行逐位异或,依次进行,最后得到 8 字节的异或结果,将该结果用 TAK 进行 DES/TDES 加密运算 
	 *<br>2:ANSIX9.19 规范,将 BLOCK1 用 TAK 做 DES 加密(只取前8 个字节的 key),加密结果与 BLOCK2 进行逐位异或后再用 TAK做 DES加密,依次进行得到 8字节的加密结果,直到最后一次采用 DES/TDES 加密
	 *<br>101:银联标准的MAC运算算法
	 */
	public byte[] getMac(byte keyIdx,byte[] dataIn,int mode);
	/**
	 * 进行 des 加解密运算(非 DUKPT)
	 * 
	 * @param keyIdx 密钥索引号,加密:TEK 索引号;解密:TDK 索引号
	 * @param dataIn 需进行 DES 运算的数据包
	 * @param mode 运算模式:
	 * @see Ped#DES_MODE_DECRYPT
	 * @see Ped#DES_MODE_ENCRYPT
	 * @see Ped#DES_CBC_DECRYPT
	 * @see Ped#DES_CBC_ENCRYPT
	 * @return  DES 运算结果数据
	 */
	public byte[] calcDES(byte keyIdx,byte[] dataIn,int mode);
	
	/**
	 * ECB 解密
	 */
	public static final int DES_MODE_DECRYPT = 0;
	/**
	 * ECB 加密
	 */
	public static final int DES_MODE_ENCRYPT = 1;
	/**
	 * CBC 解密
	 */
	public static final int DES_CBC_DECRYPT = 2;
	/**
	 * CBC 加密
	 */
	public static final int DES_CBC_ENCRYPT = 3;
	
	
	/**
	 * 获取随机数
	 * 
	 * @param len 期望获取的随机数长度
	 * @return  随机数
	 */
	public byte[] getRandom(int len);

	
	/**
	* 存入byte[]数组
	* @param key value
	* @return 成功失败
	*/
	boolean setBytesValue(String key, byte[] value);
	
	/**
	* 获取byte[]数组
	* @param key value
	* @return byte[]
	*/
	byte[] getBytesValue(String key);
	
	/**
	* 存入字符串
	* @param key value
	* @return 成功失败
	*/
	boolean setStringValue(String key, String value);
	
	/**
	* 获取字符串
	* @param key value
	* @return 字符串
	*/
	String getStringValue(String key);
	
	/**
	* 移除数据
	* @param key 
	* @return 成功失败
	*/
	boolean removeValue(String key);

	/*
    * 设置密码对话框中TextView视图组件的text
    * @param viewId 视图组件ID
    * @param value 内容值
    */
	void setPwdDialogText(int viewId,CharSequence value);
	/**
	 * 设置密码输入模式(此参数pos3不支持)
	 * @param supportbypass 模式<br/>
	 * 0x00: 必须要输入密码 <br/>
	0x01: 可以不输入密码直接确定<br/>
	0x10: 必须要输入密码，输入6位密码自动确定<br/>
	0x11: 可以不输入密码直接确定，输入6位密码自动确定
	 */
	void setSupportbypass(byte supportbypass);
}
