package cn.weipass.pos.sdk;


/**
 * 
 * 拍照操作服务类
 * <p/>
 * 
 * 获取实例的方式：WeiposImp.as().getService(Photograph.class);
 * 
 * @since 1.0
 * @author hedong
 * 
 */
public interface Photograph extends Initializer{
	/**
	 * 拍照成功
	 */
	public static final int RESULT_OK=1;
	/**
	 * 拍照错误
	 */
	public static final int RESULT_ERR=0;
	/**
	 * 取消拍照
	 */
	public static final int RESULT_CANCEL=2;
	/**
	 * 拍照
	 * @param isCrop 是否要裁剪
	 */
	public void takePicture(boolean isCrop);
	/**
	 * 设置拍照事件回调
	 * @param listener 拍照事件回调
	 */
	public void setResultListener(OnResultListener listener);
	/**
	* 从sd卡中获取照片
	*@param isCrop 是否裁剪
	*/
	public void pickImage(boolean isCrop);
	
	/**
	 * 拍照结果监听接口
	 * 
	 * @author hedong
	 * 
	 */
	public interface OnResultListener {
		/**
		* 拍照事件通知
		* @param result 是否成功标记，0表示失败，1表示成功,2表示取消
		* @param data 照片数据
		* @param err 错误消息
		*/
		void onResult(int result,byte[] data,String err);
	}
}
