package cn.weipass.pos.sdk;



/**
 * 
 * 基于TextView实现的打印设备操作类
 * <p/>
 * 
 * 获取实例的方式：WeiposImp.as().getService(Printer.class);
 * @deprecated
 * @since 1.0
 * @author hedong
 * 
 */
public interface Printer extends IPrint{
	/**
	 * 字体大小枚举值，以下为各种字体大小在各个平台的大小：<br>
	 * <table border=1>
	 *     <tr>
	 *         <td>设备类型</td>
	 *         <td>SMALL</td>
	 *         <td>MEDIUM</td>
	 *         <td>LARGE</td>
	 *         <td>EXTRALARGE</td>
	 *     </tr>
	 *     <tr>
	 *         <td>pos2</td>
	 *         <td>20x20</td>
	 *         <td>24x24</td>
	 *         <td>30x30</td>
	 *         <td>38x38</td>
	 *     </tr>
	 *     <tr>
	 *         <td>pos3</td>
	 *         <td>16x16</td>
	 *         <td>24x24</td>
	 *         <td>32x32</td>
	 *         <td>48x48</td>
	 *     </tr>
	 * </table>
	 * 单位为px。一行的宽度为384
	 * @since 1.0
	 * @author hedong
	 * 
	 */
	public enum FontSize {
		SMALL, MEDIUM, LARGE, EXTRALARGE
	}
	
	/**
	 * 字体类型枚举值
	 * <p/>
	 * normal: 正常; BOLD: 粗体 ;italic :斜体
	 * 
	 * @author Happy
	 * 
	 */
	public enum FontStyle {
		NORMAL, BOLD,ITALIC
	}

	/**
	 * 字体枚举值
	 * 
	 * @author hedong
	 * 
	 */
	public enum FontFamily {
		/**
		 * 宋体
		 */
		SONG
	}

	/**
	 * 定位纸卷黑标
	 */
	public void goBlackLabel();

	/**
	 * 向打印机发送指令和数据
	 * 
	 * @param datas
	 *            数据内容
	 * @param len
	 *            数据长度
	 */
	public void writeData(byte[] datas, int len);

	/**
	 * 从打印机读取数据
	 * 
	 * @param buffer
	 *            数据内容
	 * @param len
	 *            数据长度
	 * @return 读取的数据长度
	 */
	public int readData(byte[] buffer, int len);
	
	/**
	 * 打印文本内容
	 * 
	 * @param text
	 *            内容
	 * @param family {@link FontFamily}字体
	 * @see FontFamily
	 * @param size {@link FontSize} 字体大小。
	 * @see FontSize
	 * @param style {@link FontStyle} 字体样式
	 * @see FontStyle
	 * @param gravity {@link cn.weipass.pos.sdk.IPrint.Gravity} 打印位置
	 * @see IPrint.Gravity
	 */
	public void printText(String text, FontFamily family, FontSize size, FontStyle style, Gravity gravity);
	
}
