package cn.weipass.pos.sdk;

import cn.weipass.service.sam.SamResult;

/**
 *Psam芯片操作类
 * <br>
 * 获取实例的方式：WeiposImp.as().getService(PsamManager.class);
 * @since 1.0
 * @author hedong
 * 
 */
public interface PsamManager extends Initializer{
	/**
	 * 卡槽1
	 */
	public static final byte SLOT1=0x1;
	/**
	 * 卡槽2
	 */
	public static final byte SLOT2=0x2;
	/**
	 * 重置
	 */
	public void reset();
	
	/**
	 * 向psam芯片发送指令
	 * @param cmd
	 * @return
	 */
	public SamResult doCommand(byte[] cmd);

	/**
	 * 设置波特率，例如：setBaund("410113"),这个数据是TLV格式的,如果为null将会设置成默认<br/>
	 * 41 是标签<br/>
	 * 01 是长度<br/>
	 * 13 是波特率 38400<br/>
	 * 以下为波特率代号对应的值参照表：<br/>
	 * <table border=1>
	 *     <tr>
	 *         <td>波特率代号</td>
	 *         <td>波特率值</td>
	 *     </tr>
	 *     <tr>
	 *         <td>11</td>
	 *         <td>9600</td>
	 *     </tr>
	 *     <tr>
	 *         <td>12</td>
	 *         <td>19200</td>
	 *     </tr>
	 *     <tr>
	 *         <td>13</td>
	 *         <td>38400</td>
	 *     </tr>
	 *     <tr>
	 *         <td>14</td>
	 *         <td>76800</td>
	 *     </tr>
	 * </table>
	 * @param baund 波特率
	 */
	public void setBaund(String baund);
	/**
	 * 选择卡槽
	 * @param slot 卡槽标志
	 * @see #SLOT1
	 * @see #SLOT2
	 */
	public void setSelectSlot(byte slot);
}
