package cn.weipass.pos.sdk;

import cn.shellinfo.wall.remote.ParamMap;

/**
 * push服务管理类
 * 
 * @author hedong
 * 
 */
public interface PushManager extends Initializer{
	/**
	 * push数据消费者
	 * 
	 * @author hedong
	 * 
	 */
	public interface PushDataConsumer {
		/**
		 * 处理从服务端push过来的数据 如果返回true，data数据将不会传递到下一个消费者，反之则传递下去
		 * 
		 * @param data
		 *            服务端push过来的数据
		 * @return true：处理完成；false：不处理或者没有处理
		 */
		public boolean consume(ParamMap data);
	}

	/**
	 * 心跳状态监控回调对象
	 * 
	 * @author hedong
	 * 
	 */
	public interface HeartStatusListener {
		/**
		 * 上线回调
		 */
		public void onActive();

		/**
		 * 断线回调
		 */
		public void onInactive();
	}

	/**
	 * 注册push数据消费者 放在消费队列的最前面
	 * 
	 * @param pkgName 消费者的包名
	 * @param consumer
	 *            push数据消费者
	 */
	public void registerPushDataConsumer(String pkgName,PushDataConsumer consumer);

	/**
	 * 注销push数据消费者
	 * 
	 * @param pkgName 消费者的包名
	 * @return
	 */
	public boolean unregisterPushDataConsumer(String pkgName);

	/**
	 * 注册心跳状态监听回调对象
	 * 
	 * @param listener
	 */
	public void registerHeartListener(HeartStatusListener listener);

	/**
	 * 注销心跳状态监听回调对象
	 * 
	 * @param listener
	 * @return
	 */
	public boolean unregisterHeartListener(HeartStatusListener listener);
}
