package cn.weipass.pos.sdk;

/**
 * RSA加解密管理类
 * 获取实例的方式：WeiposImp.as().getService(RSAManager.class);
 * Created by hedong on 2016/7/7.
 */
public interface RSAManager {
    /**
     * 生成秘钥对
     * @param len 指定密匙长度（取值范围：512～2048）
     * @return 公钥数据
     */
    public byte[] generateKeyRSA(int len);

    /**
     * 获得保存的公钥
     * @return
     */
    byte[] getPublicKey();

    /**
     * 使用私钥解码公钥加密的数据
     * @param inData 公钥加密的数据
     * @return 解密后的数据
     */
    byte[] decrypt(byte[] inData);

    /**
     * 私钥签名
     * @param inData 待签名数据
     * @return 签名后的数据
     */
    byte[] sign(byte[] inData);

    /**
     * 保存rsa公私钥对
     * @param privateKey 私钥数据
     * @param publicKey 公钥数据
     * @return 操作是否成功
     */
    boolean saveSecretKeys(byte[] privateKey,byte[] publicKey);
}
