package cn.weipass.pos.sdk;

import cn.weipass.service.scan.IScanCallback;
import cn.weipass.service.scan.ScanRuleBean;

/**
 * 扫码设备操作类，支持扫描条形码和二维码
 * 获取实例的方式：WeiposImp.as().getService(Scanner.class);
 *
 * @author hedong
 * @since 1.0
 */
public interface Scanner extends Initializer {
    /**
     * 扫码结果常量，成功
     */
    public static final int RESULT_OK = 0;
    /**
     * 扫码结果常，失败
     */
    public static final int RESULT_FAIL = 1;
    /**
     * 扫码结果常，取消
     */
    public static final int RESULT_CANCEL = 2;

    /**
     * 扫码类型，二维码
     */
    public static final int TYPE_QR = 1;
    /**
     * 扫描类型，条码
     */
    public static final int TYPE_BAR = 2;
    /**
     * 识别特定规则条码
     */
    public static final int TYPE_SPECIAL_BAR = -1;

    /**
     * 扫码结果监听接口
     *
     * @author Happy
     */
    public interface OnResultListener {
        /**
         * 结果返回事件
         *
         * @param what 事件类型
         * @param info 事件信息
         * @see Scanner#RESULT_OK
         * @see Scanner#RESULT_FAIL
         * @see Scanner#RESULT_CANCEL
         */
        public void onResult(final int what, final String info);
    }

    /**
     * 开始扫码，异步方法
     *
     * @param type             扫码类型 @see {@link #TYPE_QR}
     * @param onResultListener 扫码结果回调对象。注意：回调对象所在的Activity必须设置成 android:exported="true"，才能成功回到调用页面
     * @see OnResultListener
     */
    public void scan(int type, OnResultListener onResultListener);

    /**
     * *扫描
     * *@param type 扫描类型，1：二维码,2:条形码, 3:-1 小米之家定制需求(只返回在固定位置包含固定字符的条形码)
     *
     * @param rules    多个规则传递数组
     * @param onResultListener 结果回调对象
     **/
    public void scanFilter(int type, ScanRuleBean[] rules, OnResultListener onResultListener);

    /**
     * *
     * *初始化擎亚扫码库
     **/
    boolean initScanpEngine();

    /**
     * *
     * *解码
     **/
    void doDecode(byte[] data, int width, int height);

    /**
     * *
     * *停止扫码
     **/
    void stopScan();

    /**
     * *
     * *销毁engine
     **/
    void destoryEngine();

    /**
     * *
     * * 设置扫码结果回调对象
     **/
    void setOnResultListener(OnResultListener onResultListener);


    /*
     ** 默认竖屏 条码和二维码都支持
     */
    void scanAll(OnResultListener onResultListener);

    /*
     ** 停止扫码
     */
    void stopScanAll();
}
