package cn.weipass.pos.sdk;

import java.util.List;
import java.util.Map;

/**
 * 
 * 旺POS基础服务管理器
 * <p/>
 * 通过旺POS基础服务管理器，可以获取或调用各种基础服务。
 * <br>
 * 此功能有可能已经废弃。<br>
 * 获取实例的方式：WeiposImp.as().getService(ServiceManager.class);
 *
 * @deprecated
 * @since 1.1
 * @author Happy
 * 
 */
public interface ServiceManager extends Initializer{
	/**
	 * 保存服务提供者id的Key
	 */
	public static final String KEY_PROVIDER_ID="providerId";
	/**
	 * 保存服务提供者名称的Key
	 */
	public static final String KEY_NAME="name";
	/**
	 * 保存服务提供者图标的Key
	 */
	public static final String KEY_ICON="icon";
	/**
	 * 保存服务调用者app包名的Key
	 */
	public static final String KEY_INVOKER="KEY_INVOKER";
	/**
	 * 保存服务调用类型的Key
	 */
	public static final String KEY_SERVICE_TYPE="KEY_SERVICETYPE";
	/**
	 * 保存服务调用者回调Activity地址的Key
	 */
	public static final String KEY_CALLBACK_ACTIVITY="KEY_CALLBACK_ACTIVITY";
	/**
	 * 保存服务调用参数的Key
	 */
	public static final String KEY_PARAMS="KEY_PARAMS";
	/**
	 * 微POS基础服务管理器回调接口
	 * 
	 * @author hedong
	 * 
	 */
	public interface EventCallback {
		/**
		 * 指定服务类型的所有服务提供者列表的回调
		 * 
		 * @param providers
		 *            服务提供者列表，
		 *            <p/>
		 *            服务提供者属性包括：
		 *            <p/>
		 *            providerId String类型
		 *            <p/>
		 *            name String类型
		 *            <p/>
		 *            icon byte数组
		 * @param serviceType
		 */
		public void onGetProviders(final List<Map<String, Object>> providers,final int serviceType);
		/**
		 * 发生错误时的回调
		 * @param err 错误信息
		 */
		public void onError(final String err);
	}

	/**
	 * 支付服务
	 */
	public static final int SERVICE_TYPE_PAYMENT = 1;
	/**
	 * 收银服务
	 */
	public static final int SERVICE_TYPE_COLLECT_MONEY=2;
	/**
	 * 设置回调接口对象
	 * @param callback
	 */
	public void setEventCallback(EventCallback callback);

	/**
	 * 获取指定服务类型的所有服务提供者列表
	 * 
	 * @param serviceType
	 *            服务类型，见本接口常量定义
	 */
	public void getAllServiceProvider(int serviceType);

	/**
	 * 调用服务
	 * @param serviceType
	 *            服务类型，见本接口常量定义 
	 * @param providerId
	 *            服务提供者ID
	 * @param params
	 *            服务调用参数
	 * @param activityClassNameForCallback
	 *            服务完成后回调Activity
	 */
	public void invokeService(int serviceType,String providerId, Map<String, String> params, String activityClassNameForCallback);

}
