package cn.weipass.pos.sdk;

/**
 * 
 * 声波听声通讯设备操作类
 * <p>
 * </p>
 * 获取实例的方式：WeiposImp.as().getService(Sonar.class);
 * 
 * @since 1.0
 * @author Happy
 * 
 */
public interface Sonar extends Initializer{
	/**
	 * 开启录音和播放声音服务
	 */
	public static final int RUNTYPE_BOTH = 0;
	/**
	 * 只开启录音服务
	 */
	public static final int RUNTYPE_RECORD = 1;
	/**
	 * 只开启播放声音服务
	 */
	public static final int RUNTYPE_TRACK = 2;

	/**
	 * 声波消息接收回调接口
	 * 
	 * @author Happy
	 * 
	 */
	public interface OnReceiveListener {
		/**
		 * 声波消息事件通知
		 * 
		 * @param data
		 *            通讯数据
		 */
		public void onReceive(final byte[] data);
	}

	/**
	 * 设置声波消息事件通知监听接口
	 * 
	 * @param onReceiveListener
	 */
	public void setOnReceiveListener(OnReceiveListener onReceiveListener);

	/**
	 * 发送声波数据
	 * 
	 * @param data
	 *            数据字节
	 */
	public void send(byte[] data);
	
	/**
	 * 声波服务初始化
	 * @param runtype 运行类型，0：开启录音和播放声音服务；1：只开启录音服务；2：只开启播放声音服务
	 */
	public void init(int runtype);
	/**
	 * 暂停声波服务，建议在Activity的onPause函数中调用
	 */
	public void pause();
	/**
	 * 恢复声波服务，建议在Activity的onResume函数中调用
	 */
	public void resume();
	/**
	 * 停止声波服务，释放资源
	 */
	public void release();

}
