package cn.weipass.pos.sdk;

import android.os.Handler;

/**
 * STM32服务类,处理STM32相关业务
 * 获取实例的方式：WeiposImp.as().getService(Stm32Manager.class);
 * @author hedong
 *
 */
public interface Stm32Manager extends Initializer {
	/**
	 * 执行成功
	 */
	public static final int MSG_SUCCESS = 0;
	/**
	 * 执行失败
	 */
	public static final int MSG_FAILD = 1;
	/**
	 * 执行成功，为最新版本
	 */
	public static final int MSG_NEWEST = 2;
	/**
	 * 执行中，更新进度 当前进度值，值范围为0-100
	 */
	public static final int MSG_PROGRESS_UPDATE = 3;
	/**
	 * 擦除所有数据
	 */
	public void clearAll();
	
	/**
	 * 获取版本号
	 * @return 版本号
	 */
	public String getVersion();
	
	/**
	 * 设置回调处理对象
	 * @param handler 回调处理对象
	 */
	public void setCallbackHandler(Handler handler);
}
