package cn.weipass.service.bizInvoke;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * 请求对象
 * 
 * @author hedong
 * 
 */
public class RequestInvoke implements Parcelable {
	/**
	 * 请求方app的包名
	 */
	public String pkgName;
	/**
	 * 服务定义code，在旺pos平台定义
	 */
	public String sdCode;
	/**
	 * 合作伙伴id，在旺pos平台定义
	 */
	public String bpId;
	/**
	 * 请求类型，0:启动main Activity，1：启动指定Activity，2：启动service
	 */
	public int launchType;
	/**
	 * 请求参数
	 */
	public byte[] params;
	/**
	 * 服务端请求序列
	 */
	public String seqNo = null;
	
	/**
	 * 平台数据
	 */
	public String weiposData;

	public RequestInvoke() {

	}

	public RequestInvoke(Parcel in) {
		pkgName = in.readString();
		sdCode = in.readString();
		bpId = in.readString();
		launchType = in.readInt();
		int len = in.readInt();
		if (len > 0) {
			params = new byte[len];
			in.readByteArray(params);
		}
		seqNo = in.readString();
		weiposData=in.readString();
	}

	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeString(pkgName);
		dest.writeString(sdCode);
		dest.writeString(bpId);
		dest.writeInt(launchType);
		if(params!=null&&params.length>0){
			dest.writeInt(params.length);
			dest.writeByteArray(params);
		}
		else{
			dest.writeInt(0);
		}
		dest.writeString(seqNo);
		dest.writeString(weiposData);
	}

	public static final Parcelable.Creator<RequestInvoke> CREATOR = new Parcelable.Creator<RequestInvoke>() {
		public RequestInvoke createFromParcel(Parcel in) {
			return new RequestInvoke(in);
		}

		public RequestInvoke[] newArray(int size) {
			return new RequestInvoke[size];
		}
	};

}
