package cn.weipass.service.bizInvoke;

import android.os.Parcel;
import android.os.Parcelable;
/**
 * 服务定义描述
 * @author hedong
 *
 */
public class ServiceDefine implements Parcelable {
	/**
	 * 服务定义code，在旺pos平台定义
	 */
	public String sdCode;
	/**
	 * 合作伙伴方id，在旺pos平台定义
	 */
	public String bpId;
	/**
	 * 提供服务的app的包名，启动app用，直接启动main Activity
	 */
	public String pkgName;
	/**
	 * 提供服务的app中接收请求的activity全路径名，启动Activity用
	 */
	public String activityPath;
	/**
	 * 提供服务的app中接收请求的service定义的action名称,启动service用
	 */
	public String serviceAction;
	public ServiceDefine(){}
	public ServiceDefine(Parcel in){
		sdCode=in.readString();
		bpId=in.readString();
		pkgName=in.readString();
		activityPath=in.readString();
		serviceAction=in.readString();
	}

	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		// TODO Auto-generated method stub
		dest.writeString(sdCode);
		dest.writeString(bpId);
		dest.writeString(pkgName);
		dest.writeString(activityPath);
		dest.writeString(serviceAction);
	}
	
	public static final Parcelable.Creator<ServiceDefine> CREATOR = new Parcelable.Creator<ServiceDefine>() {
		public ServiceDefine createFromParcel(Parcel in) {
			return new ServiceDefine(in);
		}

		public ServiceDefine[] newArray(int size) {
			return new ServiceDefine[size];
		}
	};

}
