package cn.weipass.service.ped;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.Arrays;

/**
 * 密码键盘配置
 * Created by hedong on 2016/10/17.
 */
public class PwdDlgConfig implements Parcelable {
    public int offlinePIN;
    /**
     * 请求者的包名
     */
    public String pkgName;
    /**
     * 对话框布局文件id
     */
    public int layoutDialogId = 0;
    /**
     * 对话框样式资源id
     */
    public int dialogStyleId = 0;
    /**
     * 确定按钮id
     */
    public int btnOkId;
    /**
     * 取消按钮id
     */
    public int btnCancelId;
    /**
     * 擦除（退格）按钮id
     */
    public int btnEnsureId;
    /**
     * 确认按钮标题
     */
    public String titleOk;
    /**
     * 取消按钮标题
     */
    public String titleCancel;
    /**
     * 擦除(退格)按钮标题
     */
    public String titleEnsure;
    /**
     * 所有输入按钮（数字按钮+确定按钮+删除按钮）的id
     */
    public int[] allBtnIds;

    /**
     * [1~64]， TPK 的索引
     */
    public int keyIdx;
    /**
     * Pin 的长度指示串，例如，支持 4 或 6 或 8 的长度 pin 并且 支 持 不 输 入 密 码 直 接 按 确 认 键 ，
     * 则 此 字 符 串为:” 0,4,6,8” ,0 表示允许直接按确认键。密码长度最长 12 位
     */
    public String expPinLenIn;
    /**
     * 帐号，此参数为 null 时，自动全 0
     */
    public String cardNum;
    /**
     * ISO9564 格式 0
     * ISO9564 格式 1
     * ISO9564 格式 3
     * HK EPS 专用格式
     */
    public int mode;
    /**
     * Pin 扫描超时时间，单位为 ms，最大为 300000ms
     */
    public long timeout;


    public int pinType;
    /**
     * IC卡公钥模长度  脱机PIN
     */
    public int moduleLen;
    /**
     * 公钥模 脱机PIN
     */
    public byte[] module;
    /**
     * IC卡 公钥指数长度 脱机PIN
     */
    public int referLen;
    /**
     * IC卡 公钥指数 脱机PIN
     */
    public byte[] refer;

    public PwdDlgConfig() {
    }

    @Override
    public String toString() {
        return "PwdDlgConfig{" +
                "pkgName='" + pkgName + '\'' +
                ", layoutDialogId=" + layoutDialogId +
                ", dialogStyleId=" + dialogStyleId +
                ", btnOkId=" + btnOkId +
                ", btnCancelId=" + btnCancelId +
                ", btnEnsureId=" + btnEnsureId +
                ", titleOk='" + titleOk + '\'' +
                ", titleCancel='" + titleCancel + '\'' +
                ", titleEnsure='" + titleEnsure + '\'' +
                ", allBtnIds=" + Arrays.toString(allBtnIds) +
                ", keyIdx=" + keyIdx +
                ", expPinLenIn='" + expPinLenIn + '\'' +
                ", cardNum='" + cardNum + '\'' +
                ", mode=" + mode +
                ", timeout=" + timeout +
                '}';
    }

    protected PwdDlgConfig(Parcel in) {
        pkgName = in.readString();
        layoutDialogId = in.readInt();
        dialogStyleId = in.readInt();
        btnOkId = in.readInt();
        btnCancelId = in.readInt();
        btnEnsureId = in.readInt();
        titleOk = in.readString();
        titleCancel = in.readString();
        titleEnsure = in.readString();
        allBtnIds = in.createIntArray();
        keyIdx = in.readInt();
        expPinLenIn = in.readString();
        cardNum = in.readString();
        mode = in.readInt();
        timeout = in.readLong();

        offlinePIN = in.readInt();
        pinType = in.readInt();
        moduleLen = in.readInt();
        referLen = in.readInt();
        module = in.createByteArray();
        refer = in.createByteArray();

    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(pkgName);
        dest.writeInt(layoutDialogId);
        dest.writeInt(dialogStyleId);
        dest.writeInt(btnOkId);
        dest.writeInt(btnCancelId);
        dest.writeInt(btnEnsureId);
        dest.writeString(titleOk);
        dest.writeString(titleCancel);
        dest.writeString(titleEnsure);
        dest.writeIntArray(allBtnIds);
        dest.writeInt(keyIdx);
        dest.writeString(expPinLenIn);
        dest.writeString(cardNum);
        dest.writeInt(mode);
        dest.writeLong(timeout);

        dest.writeInt(offlinePIN);
        dest.writeInt(pinType);
        dest.writeInt(moduleLen);
        dest.writeInt(referLen);
        dest.writeByteArray(module);
        dest.writeByteArray(refer);

    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PwdDlgConfig> CREATOR = new Creator<PwdDlgConfig>() {
        @Override
        public PwdDlgConfig createFromParcel(Parcel in) {
            return new PwdDlgConfig(in);
        }

        @Override
        public PwdDlgConfig[] newArray(int size) {
            return new PwdDlgConfig[size];
        }
    };
}
