package cn.weipass.service.sam;

import android.os.Parcel;
import android.os.Parcelable;

public class SamResult implements Parcelable {
	public int code;
	public byte[] data;

	// public String toString() {
	// return "code:0x" + Integer.toHexString(code) + " - " +
	// Hex.bytesToHex(data);
	// }

	public SamResult(int code, byte[] bs) {
		this.code = code;
		if (bs == null) {
			bs = new byte[0];
		}
		this.data = bs;
	}
	
	public int getCode(){
		return code;
	}
	
	public byte[] getData(){
		return data;
	}

	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(code);
		if (data != null) {
			dest.writeInt(data.length);
			if (data.length > 0)
				dest.writeByteArray(data);
		}
	}
	
	private SamResult(Parcel in){
		code=in.readInt();
		int len=in.readInt();
		if(len>0){
			data=new byte[len];
			in.readByteArray(data);
		}
	}
	
	public static final Parcelable.Creator<SamResult> CREATOR = new Parcelable.Creator<SamResult>() {
		public SamResult createFromParcel(Parcel in) {
			return new SamResult(in);
		}

		public SamResult[] newArray(int size) {
			return new SamResult[size];
		}
	};
}
